<?php 			
/**
 * Version 1.0.0
 * Creation date: 17/Oct/2017
 * @Written By: S.M. Sarwar Hasan
 * Sarwar Hasan
 * DB Properties:id,reply_counter,ticket_track_id,cat_id,title,ticket_body,ticket_user,opened_time,re_open_time,re_open_by,re_open_by_type,user_type,status,assigned_on,last_replied_by,last_reply_time,ticket_rating,priroty		
 */						
class Mticket_meta extends APP_Model
{
	/**
	 * Its property id
	 *
	 * @var mixed
	 */
	public $id;
	/**
	 * Its property ticket_id
	 *
	 * @var mixed
	 */
	public $ticket_id;
	/**
	 * Its property reply_id
	 *
	 * @var mixed
	 */
	public $reply_id;
	/**
	 * Its property meta_key
	 *
	 * @var mixed
	 */
	public $meta_key;
	/**
	 * Its property meta_val
	 *
	 * @var mixed
	 */
	public $meta_val;


	/**
	 *
	 */
	function __construct()
    {
        parent::__construct();
        $this->SetValidation();
        $this->tableName = "ticket_meta";
        $this->primaryKey = "id";
        $this->uniqueKey = array();
        $this->multiKey = array(array("ticket_id"));
        $this->autoIncField = array("id");
    }


	/**
	 * The SetValidation is generated by appsbd
	 */
	function SetValidation()
    {
        $this->validations = array(
            "id" => array("Text" => "Id", "Rule" => "max_length[10]|integer"),
            "ticket_id" => array("Text" => "Meta Key", "Rule" => "required|max_length[11]"),
            "reply_id" => array("Text" => "Reply ID", "Rule" => "max_length[11]"),
            "meta_key" => array("Text" => "Meta Key", "Rule" => "required|max_length[255]"),
        );
    }

	/**
	 * The save meta is generated by appsbd
	 *
	 * @param mixed $ticket_id It is ticket_id param.
	 * @param mixed $reply_id It is reply_id param.
	 * @param mixed $meta_key It is meta_key param.
	 * @param mixed $meta_val It is meta_val param.
	 *
	 * @return bool
	 */
	public static function save_meta($ticket_id,$reply_id,$meta_key,$meta_val){
		$obj=new self();
		$obj=new self();
		$obj->ticket_id($ticket_id);
		$obj->reply_id( '=' . $reply_id, true );
		$obj->meta_key($meta_key);
		if($obj->Select()){
			
			$obj=new self();
			$obj->meta_val($meta_val);
			$obj->SetWhereUpdate("ticket_id",$ticket_id);
			$obj->SetWhereUpdate("reply_id",$reply_id);
			$obj->SetWhereUpdate('meta_key',$meta_val);
			return $obj->Update();
		}else{
			
			$obj=new self();
			$obj->ticket_id($ticket_id);
			if(!empty($reply_id)) {
				$obj->reply_id($reply_id);
			}

			$obj->meta_key($meta_key);
			$obj->meta_val($meta_val);
			return $obj->Save();
		}
	}

	/**
	 * The get meta is generated by appsbd
	 *
	 * @param mixed $ticket_id It is ticket_id param.
	 * @param mixed $reply_id It is reply_id param.
	 * @param mixed $meta_key It is meta_key param.
	 * @param mixed $default It is default param.
	 *
	 * @return APP_Model|mixed|Mticket_meta|null
	 */
	public static function get_meta($ticket_id,$reply_id,$meta_key,$default=null){
		if($reply_id<0){
			$data=self::FindAllBy("ticket_id",$ticket_id);
			if(!empty($data)){
				return $data;
			}
		}else{
			$obj=new self();
			$obj->ticket_id($ticket_id);
			$obj->reply_id('='.$reply_id,true);
			$obj->meta_key($meta_key);
			if($obj->Select()){
				return $obj;
			}

		}
		return $default;
	}

	/**
	 * The save ticket meta is generated by appsbd
	 *
	 * @param mixed $ticket_id It is ticket_id param.
	 * @param mixed $meta_key It is meta_key param.
	 * @param mixed $meta_val It is meta_val param.
	 */
	public static function save_ticket_meta($ticket_id,$meta_key,$meta_val){
		return self::save_meta($ticket_id,0,$meta_key,$meta_val);
	}

	/**
	 * The save reply meta is generated by appsbd
	 *
	 * @param mixed $ticket_id It is ticket_id param.
	 * @param mixed $reply_id It is reply_id param.
	 * @param mixed $meta_key It is meta_key param.
	 * @param mixed $meta_val It is meta_val param.
	 *
	 * @return bool
	 */
	public static function save_reply_meta($ticket_id,$reply_id,$meta_key,$meta_val){
		return self::save_meta($ticket_id,$reply_id,$meta_key,$meta_val);
	}

	/**
	 * The get ticket all meta is generated by appsbd
	 *
	 * @param mixed $ticket_id It is ticket_id param.
	 * @param mixed $default It is default param.
	 *
	 * @return mixed|Mticket_meta[]
	 */
	public static function get_ticket_all_meta($ticket_id,$default=[]){
		return self::get_meta($ticket_id,-1,'',$default);
	}

	/**
	 * The get ticket meta is generated by appsbd
	 *
	 * @param mixed $ticket_id It is ticket_id param.
	 * @param mixed $meta_key It is meta_key param.
	 * @param mixed $default It is default param.
	 *
	 * @return APP_Model|mixed|Mticket_meta|null
	 */
	public static function get_ticket_meta($ticket_id,$meta_key,$default=null){
		return self::get_meta($ticket_id,0,$meta_key,$default);
	}

	/**
	 * The get reply meta is generated by appsbd
	 *
	 * @param mixed $ticket_id It is ticket_id param.
	 * @param mixed $reply_id It is reply_id param.
	 * @param mixed $meta_key It is meta_key param.
	 * @param mixed $default It is default param.
	 *
	 * @return APP_Model|mixed|Mticket_meta|null
	 */
	public static function get_reply_meta($ticket_id,$reply_id,$meta_key,$default=null){
		return self::get_meta($ticket_id,$reply_id,$meta_key,$default);
	}
}
